namespace ReadyPlayerMe.Core.Analytics
{
    public static class Constants
    {
        public static class EventName
        {
            public const string OPEN_PROJECT = "open project";
            public const string OPEN_DOCUMENTATION = "open documentation";
            public const string OPEN_FAQ = "open faq";
            public const string OPEN_DISCORD = "open discord";
            public const string LOAD_AVATAR_FROM_DIALOG = "load avatar from dialog";
            public const string UPDATED_PARTNER_URL = "updated partner url";
            public const string ALLOW_ANALYTICS = "allow analytics";
            public const string OPEN_DIALOG = "open dialog";
            public const string BUILD_APPLICATION = "build application";
            public const string CLOSE_PROJECT = "close project";
            public const string METADATA_DOWNLOADED = "metadata downloaded";
            public const string AVATAR_LOADED = "avatar loaded";
            public const string SET_USER_PROPERTIES = "set user properties";
            public const string CLEAR_LOCAL_CACHE = "clear local cache";
            public const string SHOW_IN_EXPLORER = "show in explorer";
            public const string SET_LOGGING_ENABLED = "set logging enabled";
            public const string SET_CACHING_ENABLED = "set caching enabled";
            public const string CHECK_FOR_UPDATES = "check for updates";
            public const string PRIVACY_POLICY = "view privacy policy";
            public const string FIND_OUT_MORE = "find out more";
            public const string OPEN_SETUP_GUIDE = "open setup guide";
            public const string OPEN_INTEGRATION_GUIDE = "open integration guide";
            public const string LOAD_QUICK_START_SCENE = "load quick start scene";
            public const string OPEN_AVATAR_DOCUMENTATION = "open avatar documentation";
            public const string OPEN_ANIMATION_DOCUMENTATION = "open animation documentation";
            public const string OPEN_AVATAR_CREATOR_DOCUMENTATION = "open avatar creator documentation";
            public const string OPEN_OPTIMIZATION_DOCUMENTATION = "open optimization documentation";
            public const string AVATAR_CREATOR_SAMPLE_IMPORTED = "Avatar creator sample imported";
            public const string INSTALL_PACKAGE = "install unity package";
        }

        public static class Properties
        {
            public const string SDK_SOURCE_URL = "sdk source url";
            public const string ENGINE_VERSION = "engine version";
            public const string RENDER_PIPELINE = "render pipeline";
            public const string SUBDOMAIN = "subdomain";
            public const string APP_NAME = "app name";
            public const string SDK_TARGET = "sdk target";
            public const string TARGET = "target";
            public const string EYE_ANIMATION = "eye animation";
            public const string VOICE_HANDLER = "voice handler";
            public const string PREVIOUS_SUBDOMAIN = "previous subdomain";
            public const string NEW_SUBDOMAIN = "new subdomain";
            public const string ALLOW = "allow";
            public const string DIALOG = "dialog";
            public const string PRODUCTION_BUILD = "production build";
            public const string AVATAR_URL = "avatar url";
            public const string APP_IDENTIFIER = "app identifier";
            public const string ALLOW_ANALYTICS = "allow analytics";
            public const string DURATION = "duration";
            public const string LOGGING_ENABLED = "logging enabled";
            public const string CACHING_ENABLED = "caching enabled";
            public const string CONTEXT = "context";
        }

        public static class Links
        {
            public const string DOCS_PARTNERS_LINK = "https://docs.readyplayer.me/ready-player-me/what-is-ready-player-me#url";
            public const string DOCS_DEFER_AGENT_LINK = "https://docs.readyplayer.me/ready-player-me/integration-guides/unity/optimize/defer-agents";
            public const string DOCS_AVATAR_LOADER_WINDOW = "https://docs.readyplayer.me/ready-player-me/integration-guides/unity/avatar-loader-window";
            public const string DOCS_AVATAR_CONFIG_LINK = "https://docs.readyplayer.me/ready-player-me/integration-guides/unity/optimize/avatar-configuration";
            public const string DOCS_AVATAR_CACHING = "https://docs.readyplayer.me/ready-player-me/integration-guides/unity/optimize/avatar-caching";
            public const string AVATARS = "https://docs.readyplayer.me/ready-player-me/api-reference/avatars";
            public const string APP_ID = "https://docs.readyplayer.me/ready-player-me/integration-guides/unity/avatar-creator/custom-avatar-creator#prerequisites";
        }
    }
}
